@extends('layouts.index')

@section('main')

    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title text-hijau" id="exampleModalLabel"><i class="bi bi-ui-checks-grid"></i> Tambah
                        Barang</h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="#">
                        <div class="mb-3">
                            {{-- <label for="recipient-name" class="col-form-label">Masukkan Kode Barang</label> --}}
                            <input type="text" name="cari_barang"
                                placeholder="Masukkan Kode Barang / Nama Barang/ Merek Barang" class="form-control"
                                onkeyup="this.value = this.value.toUpperCase()">
                        </div>

                </div>
                <div class="modal-footer">
                    <button type="submit" class="tombol_add">Cari Barang</button>
                </div>
                </form>

            </div>
        </div>
    </div>


    <div class="pc-content">
        <div class="page-header">
            <div class="page-block">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="">

                            <div class="page-header-title">
                                {{-- <h5 class="m-b-10">Tabler Icons</h5> --}}
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a class="text-decoration-none" href="/admin">Home</a>
                                </li>
                                <li class="breadcrumb-item"><a class="text-decoration-none" href="/admin_menu">{{ $data_data->proyek->divisi->nama_divisi }}</a></li>
                              
                                <li class="breadcrumb-item "  aria-current="page"><a  class="text-decoration-none" href="/consumable/{{ $data_data->id }}" class="">{{ $data_data->nama_sub_divisi }}</a></li>
                                <li class="breadcrumb-item "  aria-current="page"><a  class="text-decoration-none" href="" onclick="goBack()">KEMBALI</a></li>
                            </ul>

                        </div>

                    </div>
                </div>
            </div>
        </div>


      
        <div class="row">
            <div class="col-sm-12">

                <div class="shadow bg-light col-sm-12 p-3 " style="border-radius: 20px">
                    <div class="d-flex justify-content-between  mt-2">
                        <div class="d-flex text-center">
                            {{-- <img src="{{ asset('images/logo-1.png') }}" width="45" height="45" alt=""> --}}
                            <p class="fs-6 teks fw-bold"><i class="bi bi-dropbox"></i> Data Barang</p>
                        </div>

                        <div class="">
                            <form class="row" action="#">
                                <div class="col cont">
                                    <input type="text" name="cari_barang" value="{{ request('cari_barang') }}"
                                        class="pencarian" placeholder="Cari barang ..">
                                </div>
                                <div class="col">
                                    <button type="submit" class="ms-0 tombol_search"><i class="bi bi-search"></i></button>
                                </div>
                            </form>

                        </div>
                        <div class="d-flex text-center">
                            {{-- <img src="{{ asset('images/logo-1.png') }}" width="45" height="45" alt=""> --}}
                            <a href="/consumable/consumable/create/{{ $data_data->id }}" class="me-2 tombol_tambah"><i class="bi bi-folder-plus"></i> Tambah</a>
                            <a type="button" onclick="goBack()" class="tombol_kembali text-light"><i
                                    class="bi bi-backspace"></i> Kembali</a>
                        </div>

                    </div>

                    <div class="mt-5 ">
                        @if (count($data))
                            <div class="row row-cols-1 row-cols-md-4 g-4 ">
                                @foreach ($data as $item)
                                    <div class="col text-center m-0">
                                        <a href="/consumable/add_barang_keluar/{{ $item->id }}"
                                            class="text-decoration-none card  shadow dashnum-card dashnum-card-small  overflow-hidden "
                                            style=" height:120px">
                                            <span class="round bg-primary small"></span>
                                            <span class="round bg-primary big"></span>
                                            <div class="card-body ">
                                                <p class="fs-5 card-title">{{ $item->kode_barang }}</p>
                                                <p class="card-text m-0">{{ $item->nama_barang }}</p>
                                                <p class="card-text m-0">{{ $item->merek }}</p>
                                            </div>
                                        </a>
                                    </div>
                                @endforeach
                            </div>

                            <div class="d-flex bd-highlight mx-3 mb-3 ">
                                <div class=" ">
                                    <p class="teks-halaman mb-0">Halaman : {{ $data->currentPage() }} </p>
                                    <p class="teks-halaman mb-0">Jumlah Data : {{ $data->total() }} </p>
                                    <p class="teks-halaman mb-0">Data Per Halaman : {{ $data->perPage() }}</p>
                                </div>
                                <div class="ms-auto p-2">
                                    {{ $data->links() }}
                                </div>
                            </div>
                        @else
                            <div class="table-responsive">
                                <div class=" text-center text-danger fw-bold">
                                    <div><i class="bi bi-info-circle"></i> Barang tidak ditemukan !!!</div>
                                </div>
                            </div>
                        @endif
                    </div>

                </div>
               
                        

                        {{-- <div class="row">
                           
                                <div class="col cont">
                                    <input type="text" id="input" value="{{ request('cari_barang') }}"
                                        class="pencarian" placeholder="Masukkan Kode Barang ..">
                                </div>
                               
                        </div> --}}
                        

                    {{-- <div class="mt-5 ">

                        <div>
                            <div id="data_barang"></div>
                        </div>
                       
                    </div> --}}


            </div>
        </div>

    </div>

    <script src="http://code.jquery.com/jquery-1.11.1.min.js"></script>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script>
        $(function() {
            $('#perusahaan').on('change', function() {
                let id_perusahaan = $('#perusahaan').val();

                console.log(id_perusahaan);
                $.ajax({
                    type: 'get',
                    url: "{{ route('getdivisi') }}",
                    data: {
                        id_perusahaan: id_perusahaan
                    },
                    cache: false,

                    success: function(msg) {
                        $('#divisi').html(msg);
                    },
                    error: function(data) {
                        console.log('error: ', data);

                    }
                })
            })
        })
    </script>
    <script>
        $(document).ready(function() {
            showData()
            $("#input").keyup(function() {
                var cari = $("#input").val()
                if(cari != ""){
                    $("#data_barang").html('<p class="text-center text-muted">Mencari Barang...</p>')
                    $.ajax({
                        type: "get",
                        url: "/pencarian/{{ $data_data->id }}",
                        data: "barang=" + cari,
                        success: function(data){
                            $("#data_barang").html(data)
                        } 
                    })
                }  
                else {
                    showData()
                }
            })
        })


        function showData() {
            $.get("/data_barang/{{ $data_data->id }}", {},  function(data, status ){
                $("#data_barang").html(data);
            })
        }

    </script>


@endsection
@section('scripts')
    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $(document).ready(function() {
            getData();
        });

        function getData() {
            //datatables
            table = $('#table-1').DataTable({
                language: {
                    entries: ' Data',
                    search: 'Pencarian',
                    // url: 'https://cdn.datatables.net/plug-ins/1.11.5/i18n/de-DE.json'
                },

                "processing": true,
                "serverSide": true,
                "info": true,
                "order": [],
                "scrollX": true,
                "stateSave": true,
                "lengthMenu": [
                    [5, 10, 25, 50, 100, 200],
                    [5, 10, 25, 50, 100, 200]
                ],
                "pageLength": 10,

                lengthChange: true,

                "ajax": {
                    "url": "/consumable/keluar/get_data_barang/{{ $data_data->id }}",
                    "data": function(d) {
                        d.tglawal = $('input[name="tglawal"]').val();
                        d.tglakhir = $('input[name="tglakhir"]').val();
                    }
                },

                "columns": [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        searchable: false
                    },
                    {
                        data: 'barang',
                    },
                    {
                        data: 'nama_barang',
                    },
                    {
                        data: 'merek',
                    },
                    {
                        data: 'kategori',
                    },
                   
                    {
                        data: 'opsi',
                        // name: 'tanggal',
                    },
                    

                ],
                columnDefs: [{
                        targets: [0,],
                        render: function(data, type, row, meta) {
                            if (type === 'display') {
                                data = '<div style="font-size: 13px" >' + data + '</div>';
                            }
                            return data;
                        }
                    },
                    
                    // {
                    //     targets: 11,
                    //     render: function(data, type, row, meta) {
                    //         if (type === 'display') {
                    //             data = '<div style="font-size: 13px" >' + data + '</div>';
                    //         }
                    //         return data;
                    //     }
                    // },
                ]


            });
        }

      




        
    </script>
@endsection
